/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2004 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Collections;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Drawing; // For ToolboxBitmap
using System.Reflection;
using System.Drawing.Design;
using System.Runtime.Serialization;
using System.ComponentModel.Design.Serialization;
using System.Globalization;

namespace Borland.Data.Web
{
	public enum DataSetAction
	{
		None,
		MoveNext,
		MovePrev,
		MoveFirst,
		MoveLast,
      Cancel,
      Update,
		Delete,
		Insert,
      Apply,
      Refresh,
      Undo,
      UndoAll
	}

   #region NavigationObject
   [TypeConverter(typeof(DBWebNavObject.NavObjectConverter))]
   public sealed class DBWebNavObject : MarshalByRefObject
   {
      private DataSetAction FActionType;
      private Button FButton;
      private IDBDataSource FDBDataSource;
      private string FTableName;

      public DBWebNavObject(Button button, DataSetAction actionType,
         IDBDataSource dataSource, string tableName)
      {
         FButton = button;
         FActionType = actionType;
         FDBDataSource = dataSource;
         FTableName = tableName;
      }
      public DBWebNavObject()
      {
         FButton = null;
         FActionType = DataSetAction.None;
         FTableName = "";
      }
      public Button Button
      {
         get
         {
            return FButton;
         }
      }
      public DataSetAction Actiontype
      {
         get
         {
            return FActionType;
         }
         set
         {
            FActionType = value;
         }
      }
      public string TableName
      {
         get
         {
            return FTableName;
         }
         set
         {
            FTableName = value;
         }
      }
      public IDBDataSource DBDataSource
      {
         get
         {
            return FDBDataSource;
         }
         set
         {
            FDBDataSource = value;
         }
      }

      internal class NavObjectConverter : TypeConverter
      {
       /* This method overrides CanConvertTo from TypeConverter.
          This is called when someone wants to convert an instance of
          BdpParameter to another type.  Here, only conversion to an
          InstanceDescriptor is supported.
       */
        public override bool CanConvertTo(ITypeDescriptorContext context,
           Type destinationType)
        {
            if (destinationType == typeof(InstanceDescriptor))
            {
                return true;
            }

            // Always call the base to see if it can perform the conversion.
            return base.CanConvertTo(context, destinationType);
        }


        /* This code performs the actual conversion from a BdpParameter to an
           InstanceDescriptor.
        */
        public override object ConvertTo(ITypeDescriptorContext context,
           CultureInfo culture, object value, Type destinationType)
        {
            if (destinationType == typeof(InstanceDescriptor))
            {
               ConstructorInfo ci = typeof(DBWebNavObject).GetConstructor(
                  new Type[]{ typeof(Button), typeof(DataSetAction), typeof(IDBDataSource), typeof(String)});

                DBWebNavObject n = (DBWebNavObject) value;

                return new InstanceDescriptor(ci, new object[]{n.Button, n.Actiontype, n.DBDataSource, n.TableName});
            }
            return base.ConvertTo(context, culture, value, destinationType);
        }
      }
   }
   public class NavObjectCollection : MarshalByRefObject, IList, ICollection, IEnumerable
   {
      private ArrayList m_items = new ArrayList();

      public Type ItemType
      {
         get{ return typeof(DBWebNavObject); }
      }

      public bool IsFixedSize
      {
         get
         {
            return false;
         }
      }

      public bool IsReadOnly
      {
         get
         {
            return false;
         }
      }

      public void Clear()
      {
         m_items.Clear();
      }

      public DBWebNavObject this[int index]
      {
         get
         {
            return (DBWebNavObject) m_items[index];
         }
         set
         {
            m_items[index] = value;
      }
    }

    public DBWebNavObject this[string index]
    {
      get
      {
        return (DBWebNavObject) m_items[IndexOf(index)];
      }
      set
      {
        m_items[IndexOf(index)] = value;
      }
    }

    object IList.this[int index]
    {
      get
      {
        return m_items[index];
      }
      set
      {
        m_items[index] = value;
      }
    }

    public object SyncRoot
    {
      get
      {
        return this;
      }
    }

    public bool IsSynchronized
    {
      get
      {
        return false;
      }
    }

    public int Count
    {
      get
      {
        return m_items.Count;
      }
    }

    public void CopyTo(Array array, int index)
    {
      m_items.CopyTo(array, index);
    }

    public IEnumerator GetEnumerator()
    {
      return m_items.GetEnumerator();
    }

    public void Insert(int index, Object value)
    {
      m_items.Insert(index, value);
    }

    public bool Contains(object value)
    {
      return(-1 != IndexOf(value));
    }

    public int Indexof(Button value)
    {
      int Count = 0;
      while (Count < m_items.Count )
      {
         DBWebNavObject navObj = m_items[Count] as DBWebNavObject;
         if( navObj.Button.ID == value.ID )
            return Count;
         Count ++;
      }
      return -1;
    }

    public int IndexOf(Object value)
    {
      int Count = 0;
      while (Count < m_items.Count )
      {
        if (value == m_items[Count])
          return Count;
        Count ++;
      }
      return -1;
    }

    public void RemoveAt(int index)
    {
      m_items.RemoveAt(index);
    }

    public void Remove(Object value)
    {
      int index = IndexOf(value);
      if (index != -1 )
      {
        m_items.RemoveAt(index);
        return;
      }
    }

    public void Remove(Button value)
    {
      int index = IndexOf(value);
      if (index != -1 )
      {
        m_items.RemoveAt(index);
        return;
      }
    }

    public int Add(Object value)
    {
      if(value is DBWebNavObject)
      {
        return m_items.Add(value);
      }
      return -1;
    }

      public int Add (Button button, DataSetAction action, IDBDataSource dbDataSource, string tableName)
      {
         return Add(new DBWebNavObject(button, action, dbDataSource, tableName));
      }

      private int _cultureAwareCompare(string strA, string strB)
      {
         return CultureInfo.CurrentCulture.CompareInfo.Compare(strA, strB, CompareOptions.IgnoreKanaType | CompareOptions.IgnoreWidth | CompareOptions.IgnoreCase);
      }
   }
  #endregion

	[ProvideProperty("DataSourceAction", typeof(Button))]
	[ProvideProperty("DBDataSource", typeof(Button))]
	[ProvideProperty("TableName", typeof(Button))]
	[ToolboxBitmap(typeof(Borland.Data.Web.DBWebNavigationExtender),
	"Borland.Data.Web.DBWebNavigationExtender.bmp")]
	[Designer("Borland.Data.Web.DBWebNavExtenderDesigner")]
	public class DBWebNavigationExtender: MarshalByValueComponent, System.ComponentModel.IExtenderProvider, ISupportInitialize
	{
		private bool FEnabled;
      private NavObjectCollection FNavObjects;
		private System.ComponentModel.Container components = null;
		public DBWebNavigationExtender()
		{
			FNavObjects = new NavObjectCollection();
			FEnabled = true;
//			InitializeComponent();
		}

      void RegisterControl(Button button, DataSetAction action, IDBDataSource DBDataSource, string TableName)
      {
         switch(action)
         {
            case DataSetAction.Apply:
               (DBDataSource as IDBDataSource).RegisterApplyControl(button, TableName);
               break;
            case DataSetAction.Cancel:
               (DBDataSource as IDBDataSource).RegisterCancelControl(button, TableName);
               break;
            case DataSetAction.Delete:
               (DBDataSource as IDBDataSource).RegisterDeleteControl(button, TableName);
               break;
            case DataSetAction.Insert:
               (DBDataSource as IDBDataSource).RegisterInsertControl(button, TableName);
               break;
            case DataSetAction.MoveFirst:
               (DBDataSource as IDBDataSource).RegisterFirstControl(button, TableName);
               break;
            case DataSetAction.MoveLast:
               (DBDataSource as IDBDataSource).RegisterLastControl(button, TableName);
               break;
            case DataSetAction.MoveNext:
               (DBDataSource as IDBDataSource).RegisterNextControl(button, TableName);
               break;
            case DataSetAction.MovePrev:
               (DBDataSource as IDBDataSource).RegisterPreviousControl(button, TableName);
               break;
            case DataSetAction.Refresh:
               (DBDataSource as IDBDataSource).RegisterRefreshControl(button, TableName);
               break;
            case DataSetAction.Undo:
               (DBDataSource as IDBDataSource).RegisterUndoControl(button, TableName);
               break;
            case DataSetAction.UndoAll:
               (DBDataSource as IDBDataSource).RegisterUndoAllControl(button, TableName);
               break;
            case DataSetAction.Update:
               (DBDataSource as IDBDataSource).RegisterUpdateControl(button, TableName);
               break;
         }
      }

      #region ISupportsInitialize and IInitializable

      void ISupportInitialize.BeginInit()
      {  // Previously initializing DataSet, which is wrong;
         // the Form already takes care of this.
      }


      void ISupportInitialize.EndInit()
      {
         DBWebNavObject navObj;
         for( int i = 0; i < FNavObjects.Count; i++ )
         {
            navObj = FNavObjects[i] as DBWebNavObject;
            if( navObj.Actiontype != DataSetAction.None &&
                  !ClassUtils.IsEmpty(navObj.TableName) )
               RegisterControl(navObj.Button, navObj.Actiontype, navObj.DBDataSource, navObj.TableName);
         }
      }

      #endregion

/*      #region ISerializable
      void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
      {
      }
      #endregion */

		#region Init/Dispose
		protected override void Dispose(bool disposing) {
			if (disposing) {
						if (components != null) {
									components.Dispose();
						}
			}
			base.Dispose(disposing);
		}

		private void InitializeComponent()
		{

		}
		#endregion

		#region IExtenderProvider implementation
		bool IExtenderProvider.CanExtend(object target)
		{
			return (target is Button); //Only extend buttons
		}
		#endregion

		#region DataSourceAction
      [LocalizableCategoryAttribute("Data")]
      [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
	  [LocalizableDescriptionAttribute("NavObjects")]
      public NavObjectCollection NavObjects
      {
         get
         {
            return FNavObjects;
         }
         set
         {
            FNavObjects = value;
         }
      }

		[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl)]
		[DefaultValue(DataSetAction.None)]
		public DataSetAction GetDataSourceAction(Button control)
		{
         int index = FNavObjects.Indexof(control);
			if(index == -1)
				return DataSetAction.None;
			else
				return (FNavObjects[index] as DBWebNavObject).Actiontype;
		}

		public void SetDataSourceAction(Button control, DataSetAction value)
		{
         DBWebNavObject navObj;
         int index = FNavObjects.Indexof(control);
         if( index >= 0 )
         {
            navObj = FNavObjects[index] as DBWebNavObject;
            navObj.Actiontype = value;
         }
         else
         {
            if( value != DataSetAction.None )
               FNavObjects.Add(new DBWebNavObject(control, value, null, ""));
         }
		}

      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor))]
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl)]
		[DefaultValue("")]
		public string GetTableName(Button control)
		{
         int index = FNavObjects.Indexof(control);
			if(index == -1)
				return "";
			else
				return (FNavObjects[index] as DBWebNavObject).TableName;
		}

		public void SetTableName(Button control, string value)
		{
         DBWebNavObject navObj;
         int index = FNavObjects.Indexof(control);
         if( index >= 0 )
         {
            navObj = FNavObjects[index] as DBWebNavObject;
            navObj.TableName = value;
         }
         else
         {
            FNavObjects.Add(new DBWebNavObject(control, DataSetAction.None, null, value));
         }
		}


		[LocalizableCategoryAttribute(DBTypes.sDBWebControl)]
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
		[DefaultValue(null)]
		public IDBDataSource GetDBDataSource(Button control)
		{
         int index = FNavObjects.Indexof(control);
			if(index == -1)
				return null;
			else
				return (FNavObjects[index] as DBWebNavObject).DBDataSource;
		}

		public void SetDBDataSource(Button control, IDBDataSource value)
		{
         DBWebNavObject navObj;
         int index = FNavObjects.Indexof(control);
         if( index >= 0 )
         {
            navObj = FNavObjects[index] as DBWebNavObject;
            navObj.DBDataSource = value;
         }
         else
         {
            FNavObjects.Add(new DBWebNavObject(control, DataSetAction.None, value, ""));
         }
		}
		#endregion

      #region extender's own properties
		#region Enabled property
		[Browsable(true)]
		[DefaultValue(true)]
		[LocalizableCategory("sCategoryBehaviour")]
	        [LocalizableDescriptionAttribute("NavEnabled")]
		public bool Enabled
		{
			get { return FEnabled; }
			set { FEnabled = value; }
		}
		private bool EffectiveEnabled()
		{
			return (Enabled);
		}
		#endregion

		#region Captions
		private void UpdateConnectedComponents(DataSetAction action, string oldText, string newText)
		{
         for( int i = 0; i < FNavObjects.Count; i++ )
         {
            DBWebNavObject navObj = FNavObjects[i] as DBWebNavObject;
				if( navObj.Actiontype == action )
				{
					if (navObj.Button.Text == oldText)
						navObj.Button.Text = newText;
				}
			}
		}

/*		private string m_CaptionAdd = HandlesResources.GetString("sCaptionAdd");
		public string CaptionAdd
		{
			get { return m_CaptionAdd; }
			set { UpdateConnectedComponents(DataSourceAction.Add, m_CaptionAdd, value); m_CaptionAdd = value;}
		}
		private string m_CaptionDelete = HandlesResources.GetString("sCaptionDelete");
		public string CaptionDelete
		{
			get { return m_CaptionDelete; }
			set { UpdateConnectedComponents(DataSourceAction.Delete, m_CaptionDelete, value); m_CaptionDelete = value;}
		}
		private string m_CaptionMovePrev = HandlesResources.GetString("sCaptionMovePrev");
		public string CaptionMovePrev
		{
			get { return m_CaptionMovePrev; }
			set { UpdateConnectedComponents(DataSourceAction.MovePrev, m_CaptionMovePrev, value); m_CaptionMovePrev = value;}
		}
		private string m_CaptionMoveNext = HandlesResources.GetString("sCaptionMoveNext");
		public string CaptionMoveNext
		{
			get { return m_CaptionMoveNext; }
			set { UpdateConnectedComponents(DataSourceAction.MoveNext, m_CaptionMoveNext, value); m_CaptionMoveNext = value;}
		}
		private string m_CaptionMoveFirst = HandlesResources.GetString("sCaptionMoveFirst");
		public string CaptionMoveFirst
		{
			get { return m_CaptionMoveFirst; }
			set { UpdateConnectedComponents(DataSourceAction.MoveFirst, m_CaptionMoveFirst, value); m_CaptionMoveFirst = value;}
		}
		private string m_CaptionMoveLast = HandlesResources.GetString("sCaptionMoveLast");
		public string CaptionMoveLast
		{
			get { return m_CaptionMoveLast; }
			set { UpdateConnectedComponents(DataSourceAction.MoveLast, m_CaptionMoveLast, value); m_CaptionMoveLast = value;}
		}
		private string m_CaptionUnlink = HandlesResources.GetString("sCaptionUnlink");
		public string CaptionUnlink 
		{
			get { return m_CaptionUnlink; }
			set { UpdateConnectedComponents(DataSourceAction.Unlink, m_CaptionUnlink, value); m_CaptionUnlink = value;}
		}
		private string m_UnlinkQuestion = HandlesResources.GetString("sUnlinkQuestion");
		public string UnlinkQuestion
		{
			get { return m_UnlinkQuestion; }
			set { m_UnlinkQuestion = value; }
		}
		private string m_DeleteQuestion = HandlesResources.GetString("sDeleteQuestion");
		public string DeleteQuestion
		{
			get { return m_DeleteQuestion; }
			set { m_DeleteQuestion = value; }
		}*/
		#endregion

		#endregion


	}
}
